﻿using VIRP.EFR.DAL.Imaging.Utility;

using VIRP.EFR.BO;
using System.Linq;

namespace VIRP.EFR.BLL
{
    public class VistaImagingConfigurationService
    {
        private const string CacheKeyNamespace = "VIRP.EFR.BLL";
        private const string CacheKeyClass = "VistaImagingConfigurationService";

        static VistaImagingConfigurationService()
        {
            CacheHelper.Clear(GetCacheKey());
        }

        public VISTA_IMAGING_SERVICES_CONFIGURATION GetConfiguration(string currentUser, int currentRegistryId)
        {
            return CacheHelper.GetAdd(GetCacheKey(), 
                () =>
                {
                    return VISTA_IMAGING_SERVICES_CONFIGURATIONManager
                    .GetItems(currentUser, currentRegistryId)
                    .FirstOrDefault();
                });
        }

        private static string GetCacheKey()
        {
            return new CacheKey(
                CacheKeyNamespace,
                CacheKeyClass,
                "GetConfiguration")
                    .Build();
        }
    }
}